# MSAP_calc_session1.R 11.03.2015
#                     07.02.2017     
################################################################################
#  BEGIN SESSION
################################################################################
rm(list=ls())
setwd('C:/A/MSAP')       # go to working directory
source("MSAP_calc_1_3.r")    # load functions from MSAP_calc.r

# Read primary MSAP data from MSAP_data.txt and transform according to "Mixed
# Scoring 2" scheme of Schulz et al.
# Transformed data are available as data.frame "d" and output to "MSAP_Mix2.txt"
# --> be patient ! Takes 1 minute
d<-Extract_MSAP_epigenotypes ("MSAP_data.txt","Mix2", "MSAP_Mix2.txt",1,TRUE)

# Read transformed MSAP data and calculate population level descriptors
# Results are available as data.frame "p" and output to  "MSAP_Mix2_descr.txt"
p<-descriptive_parameters    ("MSAP_Mix2.txt","MSAP_Mix2_descr.txt")
# Ignore the warning message !

################################################################################
# Principle coordinates analysis
library(labdsv)                                #load library for PCoA analysis
d.pco<-pco(dsvdis(d[,-c(1:2)],index="sorensen"),k=10) # perform PCoA

# simple PCoA plot
plot(d.pco)

# plot population IDs instead of symbols
plot(d.pco$points[,2]~d.pco$points[,1], type="n",
     xlab=paste("PCO1 (",format(d.pco$eig[1]/sum(d.pco$eig)*100,digits=3),"%)",
                sep=""),
     ylab=paste("PCO2 (",format(d.pco$eig[2]/sum(d.pco$eig)*100,digits=3),"%)",
                sep=""),
     main="Epigenetic variation of 3 pops")
text(d.pco$points[,1],d.pco$points[,2],d[,1],cex=0.6)

par(mfrow=c(2,1))
# simple barplot of overall Shannon diversity
barplot(p$Shannon_diversity,beside=T,names.arg=p$PopID,
          ylab="Mean Shannon diversity", xlab="Population",
          ylim=c(0,max(p$Shannon_diversity)*1.2), main="Mixed2 scoring")

# barplot of Shannon diversity of different types of epi-loci
barplot(t(rbind(p$u_Shannon_diversity,p$m_Shannon_diversity,  ## 11.03.2015 changed "cbind" to "rbind" Thanks to Dafni Anastasiadi 
              p$h_Shannon_diversity)),
        beside=T,names.arg=p$PopID,
        ylab="Mean Shannon diversity", xlab="Population",
        ylim=c(0,max(cbind(p$u_Shannon_diversity,p$m_Shannon_diversity,
              p$h_Shannon_diversity))*1.4), main="Shannon diversity",
        legend.text= c("unmeth.","Me-CG","HMe-CCG"),args.legend=list(horiz=T))

################################################################################


