from numpy.lib.function_base import append
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import json
import os

def write_block(list, filename):
    with open(filename, "w") as f:
        for item in list:
            f.write("%s\n" % item)


def writePhreeqcFile(data, varying_component, current_value, previous_value):
    components = [*data["Porewater"].keys()]
    totals_str = ""
    for component in components:
        totals_str += " {}".format(component)

    phr_list = []
    phr_list.append(
        """DATABASE {}

KNOBS
-iterations 250
-convergence_tolerance 1.000000000000000e-06
-tolerance 9.999999999999999e-21
-step_size 5
-diagonal_scale 1

SELECTED_OUTPUT
-file batch_calc.out
-high_precision true
-simulation false
-state true
-distance false
-time false
-step false
-totals {}
""".format(data['Database'], totals_str))

    phr_list.append(
        """SOLUTION 1 current
temp {}
pressure {}
pH {}
pe {}
units mol/kgw""".format(
            data["Properties"]["temperature"],
            data["Properties"]["pressure"],
            data["Properties"]["pH"],
            data["Properties"]["pe"],
        )
    )

    for component in components:
        if component != varying_component:
            phr_list.append("{} {}".format(component, data["Porewater"][component]))

    phr_list.append("{} {}".format(varying_component, current_value))

    phr_list.append("")
    phr_list.append(
        """SOLUTION 2 previous
temp {}
pressure {}
pH {}
pe {}
units mol/kgw""".format(
            data["Properties"]["temperature"],
            data["Properties"]["pressure"],
            data["Properties"]["pH"],
            data["Properties"]["pe"],
        )
    )

    for component in components:
        if component != varying_component:
            phr_list.append("{} {}".format(component, data["Porewater"][component]))

    phr_list.append("{} {}".format(varying_component, previous_value))

    phr_list.append("")
    phr_list.append("USE solution none")
    phr_list.append("END")
    phr_list.append("USE solution 1")
    phr_list.append("")

    phr_list.append("SURFACE 1")
    phr_list.append("-equilibrate with solution 2")
    phr_list.append("-sites_units absolute")

    sites = [*data["Surface"].keys()]
    for site in sites:
        phr_list.append("{} {}".format(site, data["Surface"][site]))

    phr_list.append("-no_edl")
    phr_list.append("SAVE solution 1")
    phr_list.append("END")

    write_block(phr_list, "phreeqc_file.phr")
    print("--------------------------------------")
    print("INFO: file phreeqc_file.phr created")
    print("--------------------------------------")
    return 0


def readPhreeqcSelectedOutput(output_file, varying_component):

    df = pd.read_csv("{}".format(output_file), delim_whitespace=True)
    soln_row = 3  # row in txt file with resulting solution equilibration 

    return df[varying_component][soln_row]

def createLookupTable(start, end, n_values, input_dict, varying_component):

    input_data = input_dict
    with open(input_data) as f:
        data = json.load(f)
    print("-------------------------------------------")
    print("INFO: File {} loaded succesfully.".format(input_data))
    print("-------------------------------------------")

    seed_values = np.logspace(
    np.log10(start),
    np.log10(end),
    num=n_values,
    endpoint=True,
    base=10.0,
    axis=0,
    )
    seed_values = np.insert(seed_values, 0, 0, axis=0)

    df = pd.DataFrame()
    current_values = []
    prev_values = []
    new_values = []
    for seed_value_1 in seed_values:
        for seed_value_2 in seed_values:
            print(seed_value_1, seed_value_2)
            writePhreeqcFile(data, varying_component, seed_value_1, seed_value_2)
            os.system("phreeqc phreeqc_file.phr")
            new_value = readPhreeqcSelectedOutput("batch_calc.out", varying_component)
            current_values.append(seed_value_1)
            prev_values.append(seed_value_2)
            new_values.append(new_value)
        
    df['{}'.format(varying_component)] = current_values
    df['{}_prev'.format(varying_component)] = prev_values
    df['{}_new'.format(varying_component)] = new_values

    return df