#!/bin/bash

# phreeqc input file
input_file="BatchSimulationAll_backup.inp"

# check if result file exists
result_file="Result.txt"
if test -f "$result_file"; then
    echo "$result_file exists."
    rm "$result_file"
    echo "$result_file has been removed."
fi

setValue () {
    export START=$1
    export END=$2
    export STEP=$3
    local value=$(python -c "import os; import numpy as np; ConcCur = list(np.float_power(10, elem) for elem in np.arange(int(os.environ['START']), int(os.environ['END']), float(os.environ['STEP']))); ConcCur.insert(0, 0); ConcCur=map(float, ConcCur); print(ConcCur);")
    local value=$(echo "$value" | sed 's/[][]//g' | sed 's/,//g' )
    echo "$value"
}

declare -A radionuclides
# Sparse table
#radionuclides[U(6)]="$(setValue "-13" "-7" "0.5")"
# Dense table
radionuclides[U(6)]="$(setValue "-13" "-7" "0.1")"
echo "U(6): ${radionuclides[U(6)]}"

# Remark where to set radionuclides concentration 
# of current time step
declare -A line_num_cur
line_num_cur[U(6)]=28

# Remark where to set radionuclides concentration 
# of previous time step
declare -A line_num_prev
line_num_prev[U(6)]=40

# add headline in result file
elements=${!radionuclides[@]}
echo "$elements"

for element in $elements
do
  echo -ne "${element}_cur\t" >> "$result_file"
done

for element in $elements
do
  echo -ne "${element}_prev\t" >> "$result_file"
done

for element in $elements
do
  echo -ne "$element\t" >> "$result_file"
done

# add matrix
echo "" >> "$result_file"
for U_cur in ${radionuclides[U(6)]}
do
  for U_prev in ${radionuclides[U(6)]}
  do
    # set radionuclides concentrations of current and previous time step
    sed -i "${line_num_cur[U(6)]}s/.*/U(6) $U_cur/g;
    ${line_num_prev[U(6)]}s/.*/U(6) $U_prev/g" "$input_file"

    # call phreeqc for execution
    # phreeqc input file output file database
    phreeqc "$input_file" ./test.out ./SMILE_EDH_TDB_2020_07_13_ESTRALSCM_ohneCaHCO3+_backup.dat
                                                                
    # extract data from phreeqc result file
    awk -v U_cur="$U_cur" -v U_prev="$U_prev" 'NR==5 {print U_cur"\t"U_prev"\t"$9}' BatchSimulation.out >> "$result_file"
  done
done
