#include <vector>
#include <fstream>
#include <iostream>
#include <time.h>
#include <cmath>
#include <list>

//typedef  double real;
using namespace std;

bool IsBCNode(int,std::vector<int>);
bool IsNodeInactive(int,std::vector<int>);
bool NodeInList(int n,std::list<int>nodes_active);

int main(int argc, char *argv[])
{
  clock_t start, end;
  start = clock();
  double cpuTime;
  //data structures
  std::vector<float>u_new;
  std::vector<float>u;
  std::vector<float>u_bc;
  float u0;
  float dx,dy,dt;
  float S0,Kf,Q;
  long i, j;
  int ix;
  int jy;
  std::ofstream out_file;
  std::ofstream aux_file;
  std::vector<int>bc_nodes;
  std::vector<int>nodes_inactive;
  int n,nn;
  float x,y,x0,y0;
  //output
  out_file.open("out.txt");
  aux_file.open("cputime.txt");
  //-----------------------------------------------------------------------
  //parameters
  ix = 43;
  jy = 33;
  dx = 1000.;
  dy = 1000.;
  dt = 0.25e6; // sec
  S0 = 1e-5;
  Kf = 1e-5;                                     // m/s
  //Q = 3.171e-9; // 100mm/year : 0.1/365/86400 = 3.171e-9 m/s
  Q = 0.; //1e-5;
  u0 = 300.;
  x0 = 4423656.0991422;
  y0 = 5716944.1927754;
  //memory allocation
  u.resize(ix*jy);
  u_new.resize(ix*jy);
  //-----------------------------------------------------------------------
  //geometry
   //Einlesen der aktiven Knoten
  std::list<int>nodes_active;
  std::ifstream active_nodes_file;
  active_nodes_file.open("ActiveNodes.txt");
  if(!active_nodes_file.good()) // Check is file existing
  {
    cout << "Error: file could not be opened" << endl;
    return 0;
  }
//OK file not found
  int na;
  while(!active_nodes_file.eof())
  {
    active_nodes_file >> na;
    nodes_active.push_back(na);
  }
   //Sortieren der aktiven Knoten
  nodes_active.sort();
  std::ofstream active_nodes_file_test;
  active_nodes_file_test.open("ActiveNodesSorted.txt");
// Vektor-Variante
/*
  for(i=0;i<nodes_active.size();i++)
  {
    active_nodes_file_test << nodes_active[i] << endl;
  }
*/
  list<int>::const_iterator p = nodes_active.begin();
  while(p!=nodes_active.end())
  {
    active_nodes_file_test << *p << endl;
    ++p;
  }
  active_nodes_file_test.close();
   //Bestimmen der inaktiven Knoten
  std::ofstream inactive_nodes_file;
  inactive_nodes_file.open("InactiveNodes.txt");
  for(j=0;j<jy;j++)
  {
    nn = j*ix;
    for( i=0;i<ix;i++)
    {
      n = nn+i;
      if(!NodeInList(n,nodes_active))
        nodes_inactive.push_back(n);
    }
  }
  for(i=0;i<nodes_inactive.size();i++)
  {
    inactive_nodes_file << nodes_inactive[i] << endl;
  }
  inactive_nodes_file.close();
  //-----------------------------------------------------------------------
  //initial conditions
  for(j=0;j<jy;j++)
  {
    nn = j*ix;
    for( i=0;i<ix;i++)
    {
      n = nn+i;
      u[n] = u0;
      u_new[n] = u0;
    }
  }
  //-----------------------------------------------------------------------
  //boundary conditions
  // BC nodes from input file
  //top and bottom
  int l;
  for( i=0;i<ix;i++)
  {
    bc_nodes.push_back(i); u[i] = u0;  u_new[i] = u0;
    l = ix*(jy-1)+i;
    if(l>1402&&l<1408)
    {
      bc_nodes.push_back(l); u[l] = u0;  u_new[l] = u0;
    }
    else
    {
      bc_nodes.push_back(l); u[l] = u0;  u_new[l] = u0;
    }
  }
  //left and right side
  for(j=1;j<jy-1;j++)
  {
    l = ix*j;
    if(j>4&&j<9)
    {
      bc_nodes.push_back(l); u[l] = 800.;  u_new[l] = 800.;
    }
    else
    {
      bc_nodes.push_back(l); u[l] = u0;  u_new[l] = u0;
    }
    l = ix*j+ix-1;
    bc_nodes.push_back(l); u[l] = u0;  u_new[l] = u0;
  }
  //bc_nodes.push_back(1075); u[172] = 10.0;  u_new[172] = 10.0;
  //bc_nodes.push_back(1118); u[215] = 10.0;  u_new[215] = 10.0;
  //bc_nodes.push_back(1161); u[258] = 10.0;  u_new[258] = 10.0;
  //bc_nodes.push_back(1204); u[301] = 10.0;  u_new[301] = 10.0;
  //optimization
  double dx2 = dx*dx;
  double dy2 = dy*dy;
  //=======================================================================
  int tn = 10;
  //output
  for(int t=0;t<tn;t++)
  {
    //-----------------------------------------------------------------------
    //time step
    // WW please parallize this loop
      for( j=0;j<jy;j++)
      {
        nn = j*ix;
        for( i=0;i<ix;i++)
        {
          n = nn+i;
          if(IsBCNode(n,bc_nodes))
            continue;
          if(IsNodeInactive(n,nodes_inactive))
            continue;
          u_new[n] = u[n] \
                   + Kf/S0*dt/dx2 * (u[n+1]-2*u[n]+u[n-1]) \
                   + Kf/S0*dt/dy2 * (u[(j+1)*ix+i]-2*u[n]+u[(j-1)*ix+i]) \
                   + Q/S0;
        }
      }
      // WW
      //-----------------------------------------------------------------------
      // check steady state
      //-----------------------------------------------------------------------
      //save time step
      for(int j=0;j<jy;j++)
        for(int i=0;i<ix;i++)
        {
          u[j*ix+i] = u_new[j*ix+i];
        }
      //-----------------------------------------------------------------------
      //output:values
    //if((t%10)==0)
    {
      out_file << "ZONE T=\"BIG ZONE\", I=" << ix << ", J=" << jy <<", DATAPACKING=POINT"  << std::endl;
      for(int j=0;j<jy;j++) //y
      {
        y = y0 + j*dy;
        nn = j*ix;
        for(int i=0;i<ix;i++) //x
        {
          n = nn+i;
          x = x0 + i*dx;
          if(IsNodeInactive(n,nodes_inactive))
            out_file << x << "\t" << y << "\t" << 0.0 << std::endl;
          else
            out_file << x << "\t" << y << "\t" << u_new[n] << std::endl;
        }
      }
    }
/*
  //-----------------------------------------------------------------------
  //output:MSH
  std::ofstream msh_file;
  msh_file.open("2dfd.msh");
  msh_file << "#FEM_MSH" << std::endl;
  msh_file << " $PCS_TYPE" << std::endl;
  msh_file << "  GROUNDWATER_FLOW" << std::endl;
  msh_file << " $NODES" << std::endl;
  msh_file << "  " << ix*jy << std::endl;
  for(int j=0;j<jy;j++)
  {
    y = y0 + j*dy;
    nn = j*ix;
    for(int i=0;i<ix;i++)
    {
      n = nn+i;
      x = x0 + i*dx;
      msh_file << n << "\t" << x << "\t" << y << "\t" << 0 << std::endl;
    }
  }
  msh_file << " $ELEMENTS" << std::endl;
  msh_file << "  " << (ix-1)*(jy-1) << std::endl;
  int c=0;
  for(int j=0;j<jy-1;j++)
  {
    nn = j*ix;
    for(int i=0;i<ix-1;i++)
    {
      n = nn+i;
      msh_file << c++ << "\t" << 0 << " quad " << n << "\t" << n+1 << "\t" << n+ix+1 << "\t" << n+ix << std::endl;
    }
  }
  msh_file << "#STOP" << std::endl;
}
      */
   }
   //=======================================================================
   //that's it
   end = clock();
   cpuTime= (end-start)/ (double)(CLOCKS_PER_SEC);
   //cpuTime = difftime(end, start)/(double)CLOCKS_PER_SEC;
   aux_file << "CPU time:" << cpuTime << std::endl;
   aux_file.close();
   return 0;
}


bool IsBCNode(int n,std::vector<int>bc_nodes)
{
   bool is_node_bc = false;
   size_t k;          // site_t is the unsigned integer type, may not good for big size problems
   for(k=0;k<(size_t)bc_nodes.size();k++)
   {
      if(n==bc_nodes[k])
      {
         is_node_bc = true;
         return is_node_bc;
      }
   }
   return is_node_bc;
}

bool IsNodeInactive(int n,std::vector<int>nodes_inactive)
{
  bool is_node_inactive = false;
  for(int k=0;k<(size_t)nodes_inactive.size();k++)
  {
    if(n==nodes_inactive[k])
    {
      is_node_inactive = true;
      return is_node_inactive;
    }
  }
  return is_node_inactive;
}

bool NodeInList(int n,std::list<int>nodes_active)
{
  list<int>::const_iterator p = nodes_active.begin();
  while(p!=nodes_active.end())
  {
   if(n==*p)
     return true;
    ++p;
  }
  return false;
}

