// 2D implicit FDM for steady state
// Neumann BC

#include <iostream>
#include "fdm.h"
#include <time.h>

extern void Gauss(double*,double*,double*,int);

int main()
{
  clock_t start, end;
  double cpuTime;
  std::ofstream aux_file;
  aux_file.open("cputime.txt");
  start = clock();
  //----------------------------------------------
std::cout << "new FDM()" << std::endl;
  FDM* fdm = new FDM();
std::cout << "fdm->SetInitialConditions()" << std::endl;
  fdm->SetInitialConditions();
std::cout << "fdm->SetBoundaryConditions()" << std::endl;
  fdm->SetBoundaryConditions();
  //----------------------------------------------
std::cout << "fdm->AssembleEquationSystem()" << std::endl;
  fdm->AssembleEquationSystem();
std::cout << "Gauss(fdm->matrix,fdm->vecb,fdm->vecx,fdm->IJ)" << std::endl;
  Gauss(fdm->matrix,fdm->vecb,fdm->vecx,fdm->IJ);
std::cout << "fdm->SaveTimeStep()" << std::endl;
  fdm->SaveTimeStep();
std::cout << "fdm->OutputResults(0)" << std::endl;
  fdm->OutputResults(0);
  //----------------------------------------------
  end = clock();
  cpuTime= (end-start)/ (double)(CLOCKS_PER_SEC);
  aux_file << "CPU time:" << cpuTime << std::endl;
  aux_file.close();
  fdm->out_file.close();
  fdm->eqs_file.close();
  delete fdm;
  return 0;
}
