#include <iostream>
#include <fstream>
using namespace std;
#include <cmath>

//extern void TestOutput(double*);

int main(int argc, char *argv[])
{
  //...........................................................
  // Input
  int n=6;
  int solver_iterations = 100;
  double eps = 1e-3;
  double x[n], x0[n];
  double y;
  for(int i=0;i<n;i++)
    x[i]=10.;
  ofstream out_file;
  out_file.open("out.txt");
  //...........................................................
  // Parameter
  double dx1,dx2,dx3,dx5,dy1,dy2,dy5;
  dx1 = 100.;
  dx2 = 1000.;
  dx3 = 1000.;
  dx5 = 1000.;
  dy1 = 500.;
  dy2 = 500.;
  dy5 = 500.;
  double T1,T2,T3,T5;
  double T12,T32,T52;
  T1 = 0.05;
  T2 = 0.05;
  T3 = 0.05;
  T5 = 0.01;
  T12 = (dx1+dx2)/(dx1/T1+dx2/T2);
  cout << "T12: " << T12 << endl;
  T32 = (dx3+dx2)/(dx3/T3+dx2/T2);
  cout << "T32: " << T32 << endl;
  T52 = (dy5+dy2)/(dy5/T5+dy2/T2);
  cout << "T52: " << T52 << endl;
  //Randbedingungen
  double h1,h4;
  h1 = 10.;
  h4 = 10.;
  double Q12,Q32,Q52,QR,QP2;
  // QR = R*dx2*dy2
  QR = 1.e-08 * dx2 * dy2;
  cout << "QR: " << QR << endl;
  QP2 = - 0.001;
  //------------------------
  // 2: Q12+Q32+Q52+QR+QP2=0
  // Q12 = c121*h1 + c122*h2
  double c121, c122;
  c121 = dy1 * T12 * 2./(dx1+dx2);
  cout << "c121: " << c121 << endl;
  c122 = - dy1 * T12 * 2./(dx1+dx2);
  cout << "c122: " << c122 << endl;
  // Q32 = c323*h3 + c322*h2
  double c322,c323;
  c323 = dy1 * T32 * 2./(dx3+dx2);
  cout << "c323: " << c323 << endl;
  c322 = - dy1 * T32 * 2./(dx3+dx2);
  cout << "c322: " << c322 << endl;
  // Q52 = C525*h5 + C522*h2
  double c525,c522;
  c525 = dx2 * T52 * 2./(dy5+dy2);
  cout << "c525: " << c525 << endl;
  c522 = - dx2 * T52 * 2./(dy5+dy2);
  cout << "c522: " << c522 << endl;
  // C121*h1 + (C122+C322+C522)*h2 + C323*h3 + C525*h5 + QR + QP2 = 0
  // a21*h1 + a22*h2 + a23*h3 + a25*h5 + a20 = 0
  double a20,a21,a22,a23,a25;
  a21 = c121;
  a22 = c122+c322+c522;
  a23 = c323;
  a25 = c525;
  a20 = QR + QP2; // -b2
  // h2 = - (C121*h1 + C323*h3 + C525*h5 + QR + QP2)/(C122+C322+C522)
  // h2 = -(C323)/(C122+C322+C522)*h3 -(C525)/(C122+C322+C522)*h5 -(C121*h1 + QR + QP2)/(C122+C322+C522)
  // h2 = -a21/a22*h1 -a23/a22*h3 - a25/a22*h5 - a20/a22;
  // h2 = b21*h1 + b23*h3 + b25*h5 + b20;
  double b20,b21,b23,b25;
  b21 = -a21/a22 * h1;
  cout << "b21: " << b21 << endl;
  b23 = -a23/a22;
  cout << "b23: " << b23 << endl;
  b25 = -a25/a22;
  cout << "b25: " << b25 << endl;
  b20 = -a20/a22;
  cout << "b20: " << b20 << endl;
  // Q12 = dy1*T12*2./dx1 x[0] + dy1*T12*2./dx1 x[1];
  //Hausaufgabe an alle zum 18.05.2018
  //c522 = dx2*T52*2./dy2;
  //c525 = dx2*T52*2./dy1;
  double a30,a32,a33,a36;
  double a50,a52,a54,a55,a56;
  double a60,a63,a65,a66;
  a20 = QR+QP2;
  a21 = c121;
  //a22 = c122 + c322 + c522;
  //...........................................................
  // Berechnung
    for(int k=0;k<solver_iterations;k++)
    {
      x0[1]=x[1];
      x0[2]=x[2];
      x0[4]=x[4];
      x0[5]=x[5];
      x[1] = 0.2408 * x[2] + 0.3211 * x[4] + 4.4181;
      x[2] = 0.4285 * x[1] + 0.5714 * x[5] + 0.0857;
      x[4] = 0.7028 * x[1] + 0.1054 * x[5] + 2.0223 ;
      x[5] = 0.8695 * x[2] + 0.1304 * x[4];
      // Ausgabe
      out_file << "Iteration step: " << k << endl;
      for(int i=0;i<n;i++)
      {
        out_file << "h" << i << ":" << x[i] << endl;
      }
      //Fehlerberechung
      y = abs(x0[1]-x[1]) + abs(x0[2]-x[2]) + abs(x0[4]-x[4]) + abs(x0[5]-x[5]);
      y = y/4.;
      //cout << y << endl;
      if(y<eps) return 1;
    }
  //...........................................................
  // Output
  return 0;
}

