#include <iostream>  // for using cout
#include <fstream>   // for using ifstream / ofstream
#include <string>    // for using string
#include <vector>    // for using vectors
#include <list>      // for using lists
#include "student.h" // for using CStudents
using namespace std; // for std functions

bool STDRead(ifstream&);
void STDSort();
bool STDWrite(ofstream&);
vector<CStudent*>std_vector;
vector<CStudent*>std_vector_sorted;

int main()
{
  //----------------------------------------------------------------
  cout << "E82: an object-oriented DB read function" << endl;
  //----------------------------------------------------------------
  // 1 File handling
  ifstream input_file; // ifstream instance
  input_file.open("HydroInformatics2015.txt");
  if(!input_file.good())               // Check is file existing
  {
    cout << "! Error: input file could not be opened" << endl;
    return 0;
  }
  //----------------------------------------------------------------
  // 2 Read data base
  STDRead(input_file);
  //----------------------------------------------------------------
  // 3 Sort data base
  STDSort();
  //----------------------------------------------------------------
  // 3 Write data base
  ofstream output_file;
  output_file.open("out.txt");
  STDWrite(output_file);
  //----------------------------------------------------------------
  return 0;
}

/**************************************************************************
STDLib-Method: 
Task: Reading all STD objects
06/2009 OK Implementation
**************************************************************************/
bool STDRead(ifstream& std_file)
{
  //----------------------------------------------------------------------
  char line[MAX_LINE];
  string line_string;
  ios::pos_type position;
  CStudent* m_std = NULL;
  //----------------------------------------------------------------------
//OK  STDDelete();  
  //----------------------------------------------------------------------
  // rewind the file
  std_file.seekg(0,ios::beg); 
  //----------------------------------------------------------------------
  // OBJ reading
  cout << "STDRead:" << endl;
  while(!std_file.eof()) 
  {
    m_std = new CStudent();
    position = m_std->Read(std_file); // from E63
    std_vector.push_back(m_std);
  } // eof
  //----------------------------------------------------------------------
  cout << "Number of data sets: " << std_vector.size() << endl;
  return true;
}

/**************************************************************************
STDLib-Method: 
Task: Sort STD objects alphabetically
07/2009 OK Implementation
**************************************************************************/
void STDSort()
{
  cout << "STDSort:" << endl;
  //----------------------------------------------------------------
  int i;
  CStudent* m_std = NULL;
  list<string>name_list;
  for(i=0;i<(int)std_vector.size();i++)
  {
    m_std = std_vector[i];
    name_list.push_back(m_std->name_last);
  }
  name_list.sort();
  //----------------------------------------------------------------
  // 
  int pos = 0;
  list<string>::const_iterator iterator;
  iterator = name_list.begin();
  string name_last;
  while(iterator != name_list.end()) 
  {
    name_last = *iterator;
    for(i=0;i<(int)std_vector.size();i++)
    {
      m_std = std_vector[i];
      if(m_std->name_last.compare(name_last)==0)
      {
        std_vector_sorted.push_back(m_std);
      }
    }
    ++iterator;
    pos++;
  }
  //----------------------------------------------------------------
  for(i=0;i<(int)std_vector_sorted.size();i++)
  {
    cout << std_vector_sorted[i]->name_last << endl;
  }
}

/**************************************************************************
STDLib-Method:
Task: Writing all STD objects
01/2016 OK Implementation
**************************************************************************/
bool STDWrite(ofstream& output_file)
{
  cout << "STDWrite:" << endl;
  CStudent* m_std = NULL;
  //----------------------------------------------------------------------
  for(int i=0;i<std_vector_sorted.size();i++)
  {
    //m_std = std_vector[i];
    m_std = std_vector_sorted[i];
    m_std->Write(output_file);
  }
  output_file << "#STOP" << endl;
  //----------------------------------------------------------------------
  return true;
}
