#include <iostream>  // for using cout
#include <fstream>   // for using ifstream / ofstream
#include <string>    // for using string
#include <vector>    // for using vectors
#include "student.h" // for using CStudents
using namespace std; // for std functions

#define MAX_ZEILE 256
bool STDRead(ifstream&);
void STDWrite(ofstream&);
vector<CStudent*>std_vector;

int main()
{
  //----------------------------------------------------------------
  cout << "E82: an object-oriented DB read function" << endl;
  //----------------------------------------------------------------
  // File handling
  ifstream input_file; // ifstream instance
  input_file.open("data_base.txt");
  ofstream output_file; // ofstream instance
  output_file.open("data_base_copy.txt");
  if(!input_file.good())               // Check is file existing
  {
    cout << "! Error: input file could not be opened" << endl;
    return 0;
  }
  //----------------------------------------------------------------
  // Read data base
  STDRead(input_file);
  //----------------------------------------------------------------
  // Write data base
  STDWrite(output_file);
  //----------------------------------------------------------------
  return 0;
}

/**************************************************************************
STDLib-Method: 
Task: Reading all STD objects
06/2009 OK Implementation
**************************************************************************/
bool STDRead(ifstream& std_file)
{
  //----------------------------------------------------------------------
  char line[MAX_ZEILE];
  string line_string;
  ios::pos_type position;
  CStudent* m_std = NULL;
  //----------------------------------------------------------------------
//OK  STDDelete();  
  //----------------------------------------------------------------------
  // rewind the file
  std_file.seekg(0,ios::beg); 
  //----------------------------------------------------------------------
  // OBJ reading, keyword loop
  cout << "STDRead" << endl;
  while (!std_file.eof()) 
  {
    std_file.getline(line,MAX_ZEILE);
    line_string = line;
    if(line_string.find("#STOP")!=string::npos)
      break;
    if(line_string.find("#STUDENT")!=string::npos)
    {
      m_std = new CStudent();
      position = m_std->Read(std_file); // from E63
      std_vector.push_back(m_std);
      std_file.seekg(position,ios::beg);
    }
  } // eof
  //----------------------------------------------------------------------
  cout << "Number of data sets: " << std_vector.size() << endl;
  return true;
}

/**************************************************************************
STDLib-Method: 
Task: Writing all STD objects
06/2009 OK Implementation
**************************************************************************/
void STDWrite(ofstream& std_file)
{
  CStudent* m_std = NULL;
  for(int i=0;i<(int)std_vector.size();i++)
  {
    m_std = std_vector[i];
    m_std->Write(std_file);
  }
  std_file << "#STOP\n";
}