#include "dialog.h"
#include "student.h"

#include <QVBoxLayout>
#include <QLineEdit>
#include <QMessageBox>

Dialog::Dialog(QWidget *parent):QDialog(parent)
{
  //---------------------------------------------
  //read
  ifstream input_file; // ifstream instance
  input_file.open("data_set.txt");
  if(!input_file.good())               // Check is file existing
  {
    QMessageBox msgBox;
    msgBox.setText("Input file not found");
    msgBox.exec();
    return;
  }
  input_file.seekg(0L,ios::beg);       // Rewind file
  CStudent* m_std = new CStudent();    // CStudent instance
  m_std->Read(input_file);
  //---------------------------------------------
  //elements
  QLineEdit* lineEditNameFirst = new QLineEdit();
  //lineEditNameFirst->insert("Tom");
  lineEditNameFirst->insert(m_std->name_first.data());
  QLineEdit* lineEditNameLast = new QLineEdit();
  //lineEditNameLast->insert("Hanks");
  lineEditNameLast->insert("  Bond");
  lineEditNameLast->insert(m_std->name_last.data());
  //layout
  QVBoxLayout *mainLayout = new QVBoxLayout;
  mainLayout->addWidget(lineEditNameFirst);
  mainLayout->addWidget(lineEditNameLast);
  setLayout(mainLayout);
}

Dialog::~Dialog()
{
}

