#include "dialog.h"
#include <QFileDialog>
#include <QStringListModel>
#include <QListWidget>
#include <QVBoxLayout>
#include <QPushButton>
#include <QMessageBox>
#include <QLineEdit>
#include <string>
using namespace std;
#include "student.h"
#include <fstream>

Dialog::Dialog(QWidget *parent) : QDialog(parent)
{
  //1 Elemente anlegen
  //pushButton
  pushButtonRead = new QPushButton(tr("&Read DB"));
  pushButtonAdd = new QPushButton(tr("&Add DS"));
  pushButtonDelete = new QPushButton(tr("&Delete DS"));
  pushButtonSort = new QPushButton(tr("&Sort DS"));
  //listWidget
  name = "Tom Hanks";
  names << name << "Alice Wunderland" << "Bob Dylan" << "Carol Crow" << "Donald Dug" << "Emma Thomson";
  listWidget = new QListWidget();
  for (int row = 0; row < names.size(); ++row) {
    listWidget->addItem(names[row]);
  }
  //lineEdit
  lineEditNameFirst = new QLineEdit();
  lineEditNameFirst->insert("Tom");
  lineEditNameLast = new QLineEdit();
  lineEditNameLast->insert("Hanks");
  //2 connect
  connect(pushButtonRead,SIGNAL(clicked()),this,SLOT(on_pushButtonRead_clicked()));
  connect(pushButtonAdd,SIGNAL(clicked()),this,SLOT(on_pushButtonAdd_clicked()));
  connect(pushButtonDelete,SIGNAL(clicked()),this,SLOT(on_pushButtonDelete_clicked()));
  connect(listWidget,SIGNAL(itemSelectionChanged()),this,SLOT(on_listWidget_clicked()));
  connect(pushButtonSort,SIGNAL(clicked()),this,SLOT(on_pushButtonSort_clicked()));
  //3 Layout
  QVBoxLayout *leftTopLayout = new QVBoxLayout;
  leftTopLayout->addWidget(lineEditNameFirst);
  leftTopLayout->addWidget(lineEditNameLast);
  QVBoxLayout *leftLayout = new QVBoxLayout;
  leftLayout->addLayout(leftTopLayout);
  leftLayout->addWidget(listWidget);
  QVBoxLayout *rightLayout = new QVBoxLayout;
  rightLayout->addWidget(pushButtonRead);
  rightLayout->addWidget(pushButtonAdd);
  rightLayout->addWidget(pushButtonDelete);
  rightLayout->addWidget(pushButtonSort);
  rightLayout->addStretch();
  QHBoxLayout *mainLayout = new QHBoxLayout;
  mainLayout->addLayout(leftLayout);
  mainLayout->addLayout(rightLayout);
  setLayout(mainLayout);
}

Dialog::~Dialog()
{
}

void Dialog::on_pushButtonRead_clicked()
{
    //----------------------------------------------------------------
    // 1 File handling
    ifstream input_file; // ifstream instance
    QString fileName = QFileDialog::getOpenFileName(this, "Select DB file to open", "","DB files (*.txt)");
    if (fileName.isEmpty())
      return;
    //QFileInfo fi(fileName);
    //string base = fi.absoluteDir().absoluteFilePath(fi.completeBaseName()).toStdString();
    string file_name = fileName.toStdString();
    //input_file.open("C:/HydroInformatics2015.txt");
    input_file.open(file_name.data());
    if(!input_file.good())               // Check is file existing
    {
      cout << "! Error: input file could not be opened" << endl;
      return;
    }
    //----------------------------------------------------------------
    // 2 Read data base
    STDRead(input_file);
    //----------------------------------------------------------------
    // 3 Update data list
    listWidget->clear(); //?
    names.clear();
    CStudent* m_std = NULL;
    string name_s;
    for(int i=0;i<(int)std_vector.size();i++)
    {
      m_std = std_vector[i];
      name_s = m_std->name_first + "," + m_std->name_last;
      name = name_s.data();
      names << name;
    }
    for (int row = 0; row < names.size(); ++row) {
      listWidget->addItem(names[row]);
    }
}


void Dialog::on_pushButtonAdd_clicked()
{
  QMessageBox msgBox;
  msgBox.setText("pushButtonAdd clicked");
  msgBox.exec();
}

void Dialog::on_pushButtonDelete_clicked()
{
  QMessageBox msgBox;
  msgBox.setText("pushButtonDelete clicked");
  msgBox.exec();
}

void Dialog::on_pushButtonSort_clicked()
{
  //QMessageBox msgBox;
  //msgBox.setText("pushButtonSort clicked");
  //msgBox.exec();
  STDSort();
  listWidget->clear(); //?
  names.clear();
  CStudent* m_std = NULL;
  string name_s;
  for(int i=0;i<(int)std_vector.size();i++)
  {
    m_std = std_vector[i];
    name_s = m_std->name_first + " " + m_std->name_last;
    name = name_s.data();
    names << name;
  }
  for (int row = 0; row < names.size(); ++row) {
    listWidget->addItem(names[row]);
  }
}

void Dialog::on_listWidget_clicked()
{
  QMessageBox msgBox;
  msgBox.setText("listWidget clicked");
  msgBox.exec();
  lineEditNameFirst->clear();
  lineEditNameFirst->insert("Meg");
  lineEditNameLast->clear();
  lineEditNameLast->insert("Ryan");
}

/*
void currentItemChanged ( QListWidgetItem * current, QListWidgetItem * previous )
void currentRowChanged ( int currentRow )
void currentTextChanged ( const QString & currentText )
void itemActivated ( QListWidgetItem * item )
void itemChanged ( QListWidgetItem * item )
void itemClicked ( QListWidgetItem * item )
void itemDoubleClicked ( QListWidgetItem * item )
void itemEntered ( QListWidgetItem * item )
void itemPressed ( QListWidgetItem * item )
void itemSelectionChanged ()
*/
