#include <iostream> // for using cout
#include <fstream>  // for using streams
#include <vector>   // for using vectors
#include <list>     // for using lists
#include "student.h"

#define MAX_LINE 256

vector<CStudent*>std_vector; // Declaration of vector
vector<CStudent*>std_vector_sorted;

CStudent::CStudent()
{
  name_first = "Tom";
  name_last = "Hanks";
  course = "Acting";
  year = 2007;
  bmp_id = -1;
  home_work_I = 0;
  home_work_II = 0;
  credit = 0;
  birthday = "01.01.1980";
  nation = "one-world-is-enough-for-all-of-us";
  gender = "male/female (you never know)";
  id = -1;
  email = "xyz@xyz.eu";
  operation_system = "Windows";
}

CStudent::~CStudent()
{
}

CStudentAEG::CStudentAEG()
{
  course = "AEG";
}

long CStudent::GetBankAccount()
{
	return bank_account;
}

void CStudent::SetBankAccount(long lvalue)
{
	bank_account=lvalue;
}

void CStudent::Read(ifstream* input_file)
{
  string my_string;                 // Instance of class string
  *input_file >> my_string;          // Reading a string from file
  cout << my_string.data() << endl; // Output of string to screen
}

/**************************************************************************
STD object read function
01/2007 OK/WW Implementation
**************************************************************************/
ios::pos_type CStudent::ReadDataSet(ifstream &input_file)
{
  //----------------------------------------------------------------------
  string input_line;
  char buffer[MAX_LINE]; // MAX_LINE
  long ldummy;
  ios::pos_type position;
  //----------------------------------------------------------------------
  while(true)
  {
    position = input_file.tellg();
    input_file.getline(buffer,MAX_LINE);
    input_line = buffer;
	if(input_line.size()<1) // empty line
      continue; 
    // Dealing with keywords
    if(input_line.find('#')!=string::npos) // keyword found
      return position;
    // Dealing with subkeywords
    if(input_line.find("$NAME_FIRST")!=string::npos)
    {
      input_file.getline(buffer,MAX_LINE);
      input_line = buffer;
      name_first = input_line;
    }
    if(input_line.find("$NAME_LAST")!=string::npos)
    {
      input_file >> name_last;
    }
    if(input_line.find("$COURSE")!=string::npos) 
    {
      input_file >> course;
    }
    if(input_line.find("$YEAR")!=string::npos)
    {
      input_file >> year;
    }
    if(input_line.find("$BANK_ACCOUNT")!=string::npos)
    {
      input_file >> ldummy;
      SetBankAccount(ldummy);
    }
    if(input_line.find("$BIRTHDAY")!=string::npos)
    {
      input_file >> birthday;
    }
    if(input_line.find("$NATION")!=string::npos)
    {
      input_file >> nation;
    }
    if(input_line.find("$GENDER")!=string::npos)
    {
      input_file >> gender;
    }
    if(input_line.find("$ID")!=string::npos)
    {
      input_file >> id;
    }
    if(input_line.find("$EMAIL")!=string::npos)
    {
      input_file >> email;
    }
    if(input_line.find("$ADDRESS")!=string::npos)
    {
      input_file >> city;
      input_file >> street;
    }
    if(input_line.find("$FOTO_ID")!=string::npos)
    {
      input_file >> bmp_id;
    }
    if(input_line.find("$HOME_WORK_I")!=string::npos)
    {
      input_file >> home_work_I_submitted >> home_work_I;
    }
    if(input_line.find("$HOME_WORK_II")!=string::npos)
    {
      input_file >> home_work_II_submitted >> home_work_II;
    }
    if(input_line.find("$MESSAGE")!=string::npos)
    {
      input_file >> message;
    }
    if(input_line.find("$OS")!=string::npos)
    {
      input_file >> operation_system;
    }
  }
  //----------------------------------------------------------------------
  return position;
}

void CStudent::Print(ostream &o_file)
{
  o_file << "===============" << endl;
  o_file << name_first << endl;
  o_file << name_last << endl;
  o_file << course << endl;
  o_file << id << endl;
  o_file << "===============" << endl<<endl;
}


void CStudent::Write(ostream &o_file)
{
  o_file << "#STUDENT" << endl;
  o_file << " $NAME_LAST" << endl;
  o_file << name_last << endl;
  o_file << " $NAME_FIRST" << endl;
  o_file << name_first << endl;
  o_file << " $COURSE" << endl;
  o_file << course << endl;
  o_file << " $ID" << endl;
  o_file << id << endl;
  o_file << " $BIRTHDAY" << endl;
  o_file << birthday << endl;
  o_file << " $NATION" << endl;
  o_file << nation << endl;
  o_file << " $GENDER" << endl;
  o_file << gender << endl;
  o_file << " $EMAIL" << endl;
  o_file << email << endl;
  o_file << " $FOTO_ID" << endl;
  o_file << bmp_id << endl;
  o_file << endl;
}

/**************************************************************************
Task: Read DB function
Programing:
01/2007 OK/WW Implementation
**************************************************************************/
void ReadDB(string filename)
{
  //----------------------------------------------------------------------
  // 1 File handling
  ifstream data_set_file;        // Instance of class ifstream
  //data_set_file.open(file_name.c_str()); // Open file 
  data_set_file.open("../HydroInformatics2009.dat"); // Open file 
  if(!data_set_file.good())      // Check is file existing
  {
    cout << "! Error in ReadDB(): file could not be opened" << endl;
    return;
  }
  data_set_file.seekg(0L,ios::beg); // Rewind file
  //----------------------------------------------------------------------
  // 2 Read data sets and insert to vector
  char line_char[MAX_LINE];
  string line_string;
  ios::pos_type position; // Used record the position in fstream  
  while(!data_set_file.eof()) 
  {
    data_set_file.getline(line_char,MAX_LINE);
    line_string = line_char;
    if(line_string.find("#STOP")!=string::npos)
      return;
    //....................................................................
    if(line_string.find("#STUDENT")!=string::npos) { // keyword found
      CStudent* m_std = new CStudent();
      position = m_std->ReadDataSet(data_set_file);
      data_set_file.seekg(position,ios::beg);
      std_vector.push_back(m_std); // Insert element to vector
    } // keyword found
  } // eof
  //----------------------------------------------------------------------
}

/**************************************************************************
STDLib-Method: 
Sort STD objects alphabetically
07/2009 OK Implementation
**************************************************************************/
void STDSort()
{
  //----------------------------------------------------------------
  int i;
  CStudent* m_std = NULL;
  list<string>name_list;
  for(i=0;i<(int)std_vector.size();i++)
  {
    m_std = std_vector[i];
    name_list.push_back(m_std->name_last);
  }
  //----------------------------------------------------------------
  name_list.sort();
  //----------------------------------------------------------------
  // 
  int pos = 0;
  list<string>::const_iterator iterator;
  iterator = name_list.begin();
  string name_last;
  while(iterator != name_list.end()) 
  {
    name_last = *iterator;
    for(i=0;i<(int)std_vector.size();i++)
    {
      m_std = std_vector[i];
      if(m_std->name_last.compare(name_last)==0)
      {
        std_vector_sorted.push_back(m_std);
      }
    }
    ++iterator;
    pos++;
  }
  //----------------------------------------------------------------
  for(i=0;i<(int)std_vector_sorted.size();i++)
  {
    cout << std_vector_sorted[i]->name_last << endl;
  }
  std_vector.clear();
  for(int i=0;i<(int)std_vector_sorted.size();i++)
  {
    std_vector.push_back(std_vector_sorted[i]);
  }
  std_vector_sorted.clear();
}
