#include "dialog.h"
#include "ui_dialog.h"
#include <QFileDialog>
#include <QStringListModel>
#include <QListWidget>
#include <QVBoxLayout>
#include <QPushButton>
#include <QMessageBox>
#include <QLineEdit>
#include <string>
using namespace std;
#include "student.h"

Dialog::Dialog(QWidget *parent) : QDialog(parent), ui(new Ui::Dialog)
{
  ui->setupUi(this);
  //1 Elemente anlegen
  //pushButton
  pushButton = new QPushButton(tr("&Read DB"));
  pushButtonAdd = new QPushButton(tr("&Add DS"));
  pushButtonDelete = new QPushButton(tr("&Delete DS"));
  //listWidget
  QString name = "Tom Hanks";
  QStringList names;
  names << name << "Alice Wunderland" << "Bob Dylan" << "Carol Crow" << "Donald Dug" << "Emma Thomson";
  listWidget = new QListWidget();
  for (int row = 0; row < 5; ++row) {
    listWidget->addItem(names[row]);
  }
  //lineEdit
  lineEditNameFirst = new QLineEdit();
  lineEditNameFirst->insert("Tom");
  lineEditNameLast = new QLineEdit();
  lineEditNameLast->insert("Hanks");
  //2 connect
  connect(pushButton,SIGNAL(clicked()),this,SLOT(on_pushButton_clicked()));
  connect(pushButtonAdd,SIGNAL(clicked()),this,SLOT(on_pushButtonAdd_clicked()));
  connect(pushButtonDelete,SIGNAL(clicked()),this,SLOT(on_pushButtonDelete_clicked()));
  connect(listWidget,SIGNAL(itemSelectionChanged()),this,SLOT(on_listWidget_clicked()));
  //3 Layout
  QVBoxLayout *leftTopLayout = new QVBoxLayout;
  leftTopLayout->addWidget(lineEditNameFirst);
  leftTopLayout->addWidget(lineEditNameLast);
  QVBoxLayout *leftLayout = new QVBoxLayout;
  leftLayout->addLayout(leftTopLayout);
  leftLayout->addWidget(listWidget);
  QVBoxLayout *rightLayout = new QVBoxLayout;
  rightLayout->addWidget(pushButton);
  rightLayout->addWidget(pushButtonAdd);
  rightLayout->addWidget(pushButtonDelete);
  rightLayout->addStretch();
  QHBoxLayout *mainLayout = new QHBoxLayout;
  mainLayout->addLayout(leftLayout);
  mainLayout->addLayout(rightLayout);
  setLayout(mainLayout);
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::on_pushButton_clicked()
{
  QString fileName = QFileDialog::getOpenFileName(this, "Select DB file to open", "","DB files (*.dat)");
  if (fileName.isEmpty())
    return;
  QFileInfo fi(fileName);
  string base = fi.absoluteDir().absoluteFilePath(fi.completeBaseName()).toStdString();
  listWidget->clear(); //?
  if (fi.suffix().toLower() == "dat")
  {
    ReadDB(base);
  }
}


void Dialog::on_pushButtonAdd_clicked()
{
  QMessageBox msgBox;
  msgBox.setText("pushButtonAdd clicked");
  msgBox.exec();
}

void Dialog::on_pushButtonDelete_clicked()
{
  QMessageBox msgBox;
  msgBox.setText("pushButtonDelete clicked");
  msgBox.exec();
}

void Dialog::on_listWidget_clicked()
{
  QMessageBox msgBox;
  msgBox.setText("listWidget clicked");
  msgBox.exec();
  lineEditNameFirst->clear();
  lineEditNameFirst->insert("Meg");
  lineEditNameLast->clear();
  lineEditNameLast->insert("Ryan");
}

/*
void currentItemChanged ( QListWidgetItem * current, QListWidgetItem * previous )
void currentRowChanged ( int currentRow )
void currentTextChanged ( const QString & currentText )
void itemActivated ( QListWidgetItem * item )
void itemChanged ( QListWidgetItem * item )
void itemClicked ( QListWidgetItem * item )
void itemDoubleClicked ( QListWidgetItem * item )
void itemEntered ( QListWidgetItem * item )
void itemPressed ( QListWidgetItem * item )
void itemSelectionChanged ()
*/
