#include <QApplication>
#include "plotter.h"
#include <math.h>
#define PI 3.14159265358979323846

int main(int argc, char *argv[])
{
  QApplication app(argc, argv);
  //
  int numPoints = 100;
  double x,y,alpha=1.,t;
  //
  QVector<QPointF> points0;
  QVector<QPointF> points1;
  QVector<QPointF> points2;
  // y = sin(pi*x) * exp(-alpha*t^2)
  for (int i = 0; i < numPoints+1; ++i)
  {
    x = double(i)/double(numPoints);
    t = 0.3;
    y = sin(PI*x) * exp(-alpha*t*t);
    points0.append(QPointF(x,y));
    t = 0.5;
    y = sin(PI*x) * exp(-alpha*t*t);
    points1.append(QPointF(x,y));
    t = 0.9;
    y = sin(PI*x) * exp(-alpha*t*t);
    points2.append(QPointF(x,y));
  }
  //
  Plotter plotter;
  plotter.setWindowTitle(QObject::tr("Function Plotter"));
  plotter.setCurveData(0, points0);
  plotter.setCurveData(1, points1);
  plotter.setCurveData(2, points2);
  PlotSettings settings;
  settings.minX = 0.0;
  settings.maxX = 1.0;
  settings.minY = 0.0;
  settings.maxY = 1.0;
  plotter.setPlotSettings(settings);
  plotter.show();
  return app.exec();
}

//HW3 Umschreiben fr double x
//HW4 vernnftige Werte fr a und b setzen
