#ifndef FDM_H
#define FDM_H

#include <vector>
#include <list>
#include <fstream>
#include <iostream>

typedef double real;

class FDM
{
private:
public:
  //data structures
  std::vector<double>u_new;
  std::vector<double>u;
  std::vector<double>u_bc;
  double u0;
  double dx,dy;
  int i,j;
  int ix;
  int jy;
  std::ofstream out_file;
  std::ofstream eqs_file;
  std::vector<int>bc_nodes;
  std::vector<int>nodes_inactive;
  int n,nn;
  double x,y,x0,y0;
  std::list<int>nodes_active;
  std::ifstream active_nodes_file;
  real dx2;
  real dy2;
  double* matrix;
  double* vecb;
  double* vecx;
  int IJ;
public:
    FDM();
    void SetInitialConditions();
    void SetBoundaryConditions();
    void SaveTimeStep();
    void OutputResults(int);
    void OutputMesh();
    void AssembleEquationSystem();
    void WriteEquationSystem();
    void IncorporateBoundaryConditions();
};

#endif // FDM_H
